using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

using System.IO;

namespace FileListBox_Demo
{
	/// <summary>
	/// Summary description for UserControl.
	/// </summary>
	public class FileListBox : System.Windows.Forms.UserControl
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.ListBox listBox1;

		//wewnetrzne
		private string[] listaKatalogow=null;
		private string[] listaPlikow=null;
		private string[] listaDyskow=null;
		private bool pokazujDwieKropki=true;
		private FileSystemWatcher wartownik=null;
		//konfigurowanie komponentu
		private string sciezkaKatalogu=null;
		private bool uwzglednijKatalogi=true;
		private bool uwzglednijPliki=true;
		private bool uwzglednijDyski=true;
		private bool uwzglednijKatalogNadrzedny=true;
		private string filtr=null;
		private bool mozliweZmienianieKatalogow=true;

		private void PobierzZawartoscKatalogu()
		{
			if (sciezkaKatalogu==null)
				sciezkaKatalogu=Directory.GetCurrentDirectory();

			if (!Directory.Exists(sciezkaKatalogu))
				throw new Exception("Katalog "+sciezkaKatalogu+" nie istnieje!");

			pokazujDwieKropki=(sciezkaKatalogu!=Path.GetPathRoot(sciezkaKatalogu) && uwzglednijKatalogNadrzedny);

			listBox1.Items.Clear();

			if (uwzglednijKatalogi)
				{
				if (pokazujDwieKropki) listBox1.Items.Add("[..]");
				listaKatalogow=Directory.GetDirectories(sciezkaKatalogu);
				Array.Sort(listaKatalogow);
				//listBox1.Items.AddRange(listaKatalogow);
				//for (int i=0;i<listaKatalogow.Length;i++)
					//listBox1.Items.Add("["+Path.GetFileName(listaKatalogow[i])+"]");
				foreach (string katalog in listaKatalogow)
					listBox1.Items.Add("["+Path.GetFileName(katalog)+"]");
				}
			if (uwzglednijPliki)
				{
				listaPlikow=Directory.GetFiles(sciezkaKatalogu);
				if (filtr!=null) listaPlikow=Directory.GetFiles(sciezkaKatalogu,filtr);
				Array.Sort(listaPlikow);
				//listBox1.Items.AddRange(listaPlikow);
				//for (int i=0;i<listaPlikow.Length;i++)
					//listBox1.Items.Add(Path.GetFileName(listaPlikow[i]));
				foreach (string plik in listaPlikow)
					listBox1.Items.Add(Path.GetFileName(plik));
				}
			if (uwzglednijDyski)
				{
				listaDyskow=Directory.GetLogicalDrives();
				//listBox1.Items.AddRange(listaDyskow);
				foreach (string dysk in listaDyskow)
					listBox1.Items.Add("<"+dysk.Substring(0,2)+">");

				}
		}


		public FileListBox()
		{
			// This call is required by the Windows.Forms Designer.
			InitializeComponent();
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			PobierzZawartoscKatalogu();
			UstawWartownika();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (components != null)
					components.Dispose();
			}
			base.Dispose(disposing);
		}

		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.SuspendLayout();
			// 
			// listBox1
			// 
			this.listBox1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.listBox1.ItemHeight = 16;
			this.listBox1.Location = new System.Drawing.Point(0, 0);
			this.listBox1.Name = "listBox1";
			this.listBox1.Size = new System.Drawing.Size(150, 148);
			this.listBox1.TabIndex = 0;
			this.listBox1.KeyDown += new System.Windows.Forms.KeyEventHandler(this.listBox1_KeyDown);
			this.listBox1.MouseDown += new System.Windows.Forms.MouseEventHandler(this.listBox1_MouseDown);
			this.listBox1.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.listBox1_KeyPress);
			this.listBox1.DoubleClick += new System.EventHandler(this.listBox1_DoubleClick);
			this.listBox1.MouseHover += new System.EventHandler(this.listBox1_MouseHover);
			this.listBox1.KeyUp += new System.Windows.Forms.KeyEventHandler(this.listBox1_KeyUp);
			this.listBox1.MouseUp += new System.Windows.Forms.MouseEventHandler(this.listBox1_MouseUp);
			this.listBox1.MouseMove += new System.Windows.Forms.MouseEventHandler(this.listBox1_MouseMove);
			this.listBox1.MouseEnter += new System.EventHandler(this.listBox1_MouseEnter);
			this.listBox1.MouseLeave += new System.EventHandler(this.listBox1_MouseLeave);
			this.listBox1.SelectedIndexChanged += new System.EventHandler(this.listBox1_SelectedIndexChanged);
			// 
			// FileListBox
			// 
			this.Controls.Add(this.listBox1);
			this.Name = "FileListBox";
			this.ResumeLayout(false);
		}
		#endregion

		private void listBox1_DoubleClick(object sender, System.EventArgs e)
		{
			int przesuniecie=(pokazujDwieKropki && uwzglednijKatalogi)?1:0;
			int numer=listBox1.SelectedIndex-przesuniecie; //+1 dla [..]
			int poczatekPlikow=(uwzglednijKatalogi?listaKatalogow.Length:0);
			int poczatekDyskow=poczatekPlikow+(uwzglednijPliki?listaPlikow.Length:0);

			//zmiana katalogu
			string nowaSciezkaKatalogu=null;
			if (numer==-1) nowaSciezkaKatalogu=sciezkaKatalogu+"\\..";
			if (numer>=0 && numer<poczatekPlikow) nowaSciezkaKatalogu=listaKatalogow[numer];
			if (numer>=poczatekDyskow) nowaSciezkaKatalogu=listaDyskow[numer-poczatekDyskow];
			if (nowaSciezkaKatalogu!=null && Directory.Exists(nowaSciezkaKatalogu) && mozliweZmienianieKatalogow)
				{
				sciezkaKatalogu=Path.GetFullPath(nowaSciezkaKatalogu);
				PobierzZawartoscKatalogu();
				this.OnDirectoryPathChanged(this,e);
				wartownik.Path=sciezkaKatalogu;
				}

			//podwojne klikniecie pliku
			string sciezkaPliku=null;
			if (numer>=poczatekPlikow && numer<poczatekDyskow) sciezkaPliku=listaPlikow[numer-poczatekPlikow];
			if (sciezkaPliku!=null && File.Exists(sciezkaPliku))
				this.OnFileDoubleClicked(this,e,Path.GetFullPath(sciezkaPliku));
		}

		//Wlasnosci
		[
			Category("Directory"),
			Description("The DirectoryPath determines relative or absolute path of directory visible at component.")
		]
		public string DirectoryPath
		{
			set
			{
				this.sciezkaKatalogu = value;
				PobierzZawartoscKatalogu();
				this.OnDirectoryPathChanged(this,new System.EventArgs());
				wartownik.Path=sciezkaKatalogu;
			}
			get
			{
				return this.sciezkaKatalogu;
			}
		}

		[
			Category("Directory"),
			Description("The Filter determines the mask of files in the list.")
		]
		public string Filter
		{
			set
			{
				this.filtr = value;
				PobierzZawartoscKatalogu();
			}
			get
			{
				return this.filtr;
			}
		}


		[
			Category("Directory"),
			Description("The DoubleDotVisible determines if symbol of ***** directory should be displayed.")
		]
		public bool DoubleDotVisible
		{
			set
			{
				this.uwzglednijKatalogNadrzedny = value;
				PobierzZawartoscKatalogu();
			}
			get
			{
				return this.uwzglednijKatalogNadrzedny;
			}
		}

		[
			Category("Directory"),
			Description("The DirectoriesVisible determines if list of directories should be displayed.")
		]
		public bool DirectoriesVisible
		{
			set
			{
				this.uwzglednijKatalogi = value;
				PobierzZawartoscKatalogu();
			}
			get
			{
				return this.uwzglednijKatalogi;
			}
		}

		[
			Category("Directory"),
			Description("The FilesVisible determines if list of files should be displayed.")
		]
		public bool FilesVisible
		{
			set
			{
				this.uwzglednijPliki = value;
				PobierzZawartoscKatalogu();
			}
			get
			{
				return this.uwzglednijPliki;
			}
		}

		[
			Category("Directory"),
			Description("The DrivesVisible determines if list of drives should be displayed.")
		]
		public bool DrivesVisible
		{
			set
			{
				this.uwzglednijDyski = value;
				PobierzZawartoscKatalogu();
			}
			get
			{
				return this.uwzglednijDyski;
			}
		}

		[
			Category("Directory"),
			Description("The DirectoryChangeAllowed determines if user can change current directory by double-clicking on directory in the list.")
		]
		public bool DirectoryChangeAllowed
		{
			set
			{
				mozliweZmienianieKatalogow = value;
			}
			get
			{
				return mozliweZmienianieKatalogow;
			}
		}

		[
			Category("Directory"),
			Description("The FileName expose the full path and filename to selected item.")
		]
		public string FileName
		{
			get
			{
				int przesuniecie=(pokazujDwieKropki && uwzglednijKatalogi)?1:0;
				int numer=listBox1.SelectedIndex-przesuniecie; //+1 dla [..]
				int poczatekPlikow=(uwzglednijKatalogi?listaKatalogow.Length:0);
				int poczatekDyskow=poczatekPlikow+(uwzglednijPliki?listaPlikow.Length:0);

				string pelnaSciezka=null; //ta wartosc zostanie gdy brak zaznaczonego elementu
				if (numer==-1 && przesuniecie==1) pelnaSciezka=sciezkaKatalogu+"\\..";
				if (numer>=0 && numer<poczatekPlikow) pelnaSciezka=listaKatalogow[numer];
				if (numer>=poczatekPlikow && numer<poczatekDyskow) pelnaSciezka=listaPlikow[numer-poczatekPlikow];
				if (numer>=poczatekDyskow) pelnaSciezka=listaDyskow[numer-poczatekDyskow];

				if (pelnaSciezka==null) return "";

				return Path.GetFullPath(pelnaSciezka);
			}
		}

		[
			Category("Directory"),
			Description("The DirectoryWatchingEnabled determines if files and subdirectories list is automatically uptadated.")
		]
		public bool DirectoryWatchingEnabled
		{
			set
			{
				wartownik.EnableRaisingEvents = value;
				if (wartownik.EnableRaisingEvents) PobierzZawartoscKatalogu();

			}
			get
			{
				return wartownik.EnableRaisingEvents;
			}
		}

		private void listBox1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.OnClick(e);
			this.OnSelectedFileChanged(sender,e);
		}

		//Zdarzenie SelectedFileChanged
		//1. deklaracja typu metody zdarzeniowej
		public delegate void SelectedFileChangedEventHandler(object sender,System.EventArgs e); //deklaracja typu metody zdarzeniowej
		//2. deklaracja zdarzenia i opis do niej w atrybucie
		[
			Category("Directory"),
			Description("Occures when file selectecion is changed.")
		]
		public event SelectedFileChangedEventHandler SelectedFileChanged;
		//3. pomocnicza metoda wywolujaca (launch method)
		protected virtual void OnSelectedFileChanged(object sender,System.EventArgs e)
		{
			//koniecznie trzeba sprawdzic, czy ze zdarzeniem jest w ogole zwiazana jakas metoda
			if (SelectedFileChanged!=null) SelectedFileChanged(this,e);
		}

		//Zdarzenie DirectoryPathChanged
		[
			Category("Directory"),
			Description("Occures when directory presented in component is changed.")
		]
		public event SelectedFileChangedEventHandler DirectoryPathChanged;
		protected virtual void OnDirectoryPathChanged(object sender,System.EventArgs e)
		{
			if (DirectoryPathChanged!=null) DirectoryPathChanged(this,e);
		}

		//Zdarzenie FileDoubleClicked
		public delegate void FileDoubleClickedEventHandler(object sender,System.EventArgs e,string fileName);
		[
			Category("Directory"),
			Description("Occures when one of the files in the list is double clicked.")
		]
		public event FileDoubleClickedEventHandler FileDoubleClicked;
		protected virtual void OnFileDoubleClicked(object sender,System.EventArgs e,string fileName)
		{
			if (FileDoubleClicked!=null) FileDoubleClicked(this,e,fileName);
		}

		//nadpisanie metody Refresh
		public override void Refresh()
		{
			base.Refresh(); //czy to konieczne?
			PobierzZawartoscKatalogu();
		}


		//sledzenie zmian w prezentowanym katalogu
		private void UstawWartownika()
		{
			//nic nie robimy jezeli obiekt juz istnieje
			if (wartownik!=null) return;

			wartownik = new FileSystemWatcher();

			wartownik.Path = sciezkaKatalogu;

			//sledzone czynnosci
			wartownik.NotifyFilter = NotifyFilters.FileName | NotifyFilters.DirectoryName;

			//wiazanie zdarzen wartownika z metoda Refresh
			wartownik.Changed += new FileSystemEventHandler(PrzyZmianie);
			wartownik.Created += new FileSystemEventHandler(PrzyZmianie);
			wartownik.Deleted += new FileSystemEventHandler(PrzyZmianie);
			wartownik.Renamed += new RenamedEventHandler(PrzyZmianie_Renamed);

			//aktywacja obserwowania
			wartownik.EnableRaisingEvents = true;
		}

		//wywolujace metody pomocnicza
		private void PrzyZmianie(object source, FileSystemEventArgs e)
		{
			this.PobierzZawartoscKatalogu();
		}
		private void PrzyZmianie_Renamed(object source, RenamedEventArgs e)
		{
			this.PobierzZawartoscKatalogu();
		}

		private void listBox1_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			this.OnMouseDown(e);
		}

		private void listBox1_MouseEnter(object sender, System.EventArgs e)
		{
			this.OnMouseEnter(e);
		}

		private void listBox1_MouseHover(object sender, System.EventArgs e)
		{
			this.OnMouseHover(e);
		}

		private void listBox1_MouseLeave(object sender, System.EventArgs e)
		{
			this.OnMouseLeave(e);
		}

		private void listBox1_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			this.OnMouseMove(e);
		}

		private void listBox1_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			this.OnMouseUp(e);
		}

		private void listBox1_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			this.OnKeyDown(e);
		}

		private void listBox1_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			this.OnKeyPress(e);
		}

		private void listBox1_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			this.OnKeyUp(e);
		}

		[
			Category("Directory"),
			Description("Indicates if the list box is to be single-select, multi-select, or unselectable.")
		]
		public SelectionMode SelectionMode
		{
			set
			{
				listBox1.SelectionMode = value;
			}
			get
			{
				return listBox1.SelectionMode;
			}
		}
	}
}
